/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.handler.data.IKeySetting;
import noppes.npcs.controllers.KeyController;

public class KeyConfig
implements IKeySetting {
    public String name = "key.custom.name";
    public String category = "key.custom.category";
    private int id;
    public int keyId = 44;
    public int modifer = 2;

    public KeyConfig(int id) {
        if (id < 0) {
            id *= -1;
        }
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyConfig)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        KeyConfig key = (KeyConfig)obj;
        if (this.id != key.id || this.keyId != key.keyId || this.modifer != key.modifer) {
            return false;
        }
        return this.name.equals(key.name) && this.category.equals(key.category);
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getKeyId() {
        return this.keyId;
    }

    @Override
    public int getModiferType() {
        return this.modifer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public INbt getNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.write());
    }

    public boolean isActive(int key, List<Integer> keyPress) {
        if (this.keyId != key) {
            return false;
        }
        switch (this.modifer) {
            case 1: {
                return keyPress.contains(54) || keyPress.contains(42);
            }
            case 2: {
                return keyPress.contains(157) || keyPress.contains(29);
            }
            case 3: {
                return keyPress.contains(184) || keyPress.contains(56);
            }
        }
        return true;
    }

    public void read(NBTTagCompound nbtKey) {
        this.name = nbtKey.func_74779_i("Name");
        this.category = nbtKey.func_74779_i("Category");
        this.id = nbtKey.func_74762_e("ID");
        this.keyId = nbtKey.func_74762_e("KeyID");
        if (this.keyId < 0) {
            this.keyId *= -1;
        }
        if (this.keyId < 2 || this.keyId == 157 || this.keyId == 29 || this.keyId == 54 || this.keyId == 42 || this.keyId == 184 || this.keyId == 56) {
            this.keyId = 44;
        }
        this.modifer = nbtKey.func_74762_e("ModiferType") % 4;
        if (this.modifer < 0) {
            this.modifer *= -1;
        }
    }

    @Override
    public void setCategory(String name) {
        if (name == null || name.isEmpty()) {
            name = "key.custom.category";
        }
        this.category = name;
        KeyController.getInstance().update(this.id);
    }

    @Override
    public void setKeyId(int keyId) {
        if (keyId < 2) {
            throw new CustomNPCsException("Key ID:" + keyId + " must be greater than 2", new Object[0]);
        }
        if (keyId == 157 || keyId == 29 || keyId == 54 || keyId == 42 || keyId == 184 || keyId == 56) {
            throw new CustomNPCsException("Key ID:" + keyId + " cannot be of type Ctrl, Alt or Shift", new Object[0]);
        }
        this.keyId = keyId;
        KeyController.getInstance().update(this.id);
    }

    @Override
    public void setModiferType(int type) {
        if (type < 0 || type > 3) {
            throw new CustomNPCsException("Modifer Type must be between 0 and 3", new Object[0]);
        }
        this.modifer = type;
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            name = "key.custom.name";
        }
        this.name = name;
        KeyController.getInstance().update(this.id);
    }

    @Override
    public void setNbt(INbt nbt) {
        this.read(nbt.getMCNBT());
    }

    public String toString() {
        return "KeyConfig { ID: " + this.id + "; keyID: " + this.keyId + "; modiferType: " + this.modifer + ", name: \"" + this.name + "\"; category: \"" + this.category + "\"}";
    }

    public NBTTagCompound write() {
        NBTTagCompound nbtKey = new NBTTagCompound();
        nbtKey.func_74778_a("Name", this.name);
        nbtKey.func_74778_a("Category", this.category);
        nbtKey.func_74768_a("KeyID", this.keyId);
        nbtKey.func_74768_a("ModiferType", this.modifer);
        nbtKey.func_74768_a("ID", this.id);
        return nbtKey;
    }
}

